/*____________________________________________________________________________
		Copyright (C) 2000 Network Associates, Inc.
        All rights reserved.

        $Id: CEvent.h,v 1.2 1999/09/17 04:20:50 nryan Exp $
____________________________________________________________________________*/

#ifndef Included_CEvent_h	// [
#define Included_CEvent_h

#include "pgpClassesConfig.h"

_PGP_BEGIN

// Class CEvent

class CEvent
{
	NOT_COPYABLE(CEvent)

public:
	CEvent(EVENT_TYPE type = NotificationEvent, PGPBoolean state = FALSE);

	operator KEVENT&() {return mEvent;}
	operator const KEVENT&() const {return mEvent;}

	operator PKEVENT() {return &mEvent;}

	void	Wait(PGPBoolean alertable = FALSE);
	void	Wait(PGPBoolean alertable, LARGE_INTEGER timeout);
	void	Signal(KPRIORITY increment = IO_NO_INCREMENT, 
		PGPBoolean wait = FALSE);

private:
	KEVENT	mEvent;
};


// Class CEvent member functions

inline 
CEvent::CEvent(EVENT_TYPE type, PGPBoolean state)
{
	KeInitializeEvent(&mEvent, type, state);
}

inline 
void 
CEvent::Wait(PGPBoolean alertable)
{
	KeWaitForSingleObject(&mEvent, Executive, KernelMode, alertable, NULL);
}

inline 
void 
CEvent::Wait(PGPBoolean alertable, LARGE_INTEGER timeout)
{
	KeWaitForSingleObject(&mEvent, Executive, KernelMode, alertable, 
		&timeout);
}

inline 
void 
CEvent::Signal(KPRIORITY increment, PGPBoolean wait)
{
	KeSetEvent(&mEvent, increment, wait);
}

_PGP_END

#endif	// ] Included_CEvent_h
